//	O_p.h

#ifndef _H_O_p
#define	_H_O_p

#include "OTLNp.h"

#define U_ASSUME(instance, class, inq) do {			\
	instance = (class *)(inq);						\
	U_ASSERT(instance && member(instance, class));	\
} while (0)

enum {
	OTLN_Err_BREAK_FROM_LOOP = OTLN_Err_NIFTY_ERROR + 1, 
	OTLN_Err_BAD_INSERT_INDEX
};

typedef		long						OTLN_CTopicIndex;
#define		OTLN_CTopicIndex_NONE		((OTLN_CTopicIndex)0x80000000)
#define		OTLN_CTopicIndex_START		((OTLN_CTopicIndex)0)
#define		OTLN_CTopicIndex_END		((OTLN_CTopicIndex)-1)

/*******************************************
	topic specifier
*******************************************/
class	OTLN_COutline;
class	OTLN_CTopic;

typedef struct {
	OTLN_COutline		*cOutline;
	OTLN_CTopic			*cTopic;
} OTLN_COutlineAndCTopic, *OTLN_COutlineAndCTopicP;

typedef enum {
	OTLN_COutlineIterate_NONE, 

	OTLN_COutlineIterate_UNSHY, 
	OTLN_COutlineIterate_TWIRLED_DOWN, 
	
	//	this replaces OTLN_IterateComp_STD
	OTLN_COutlineIterate_VISIBLE, 		//	implies twirled down, unshy
	
	//	this replaces OTLN_IterateComp_STD_ONSCREEN
	OTLN_COutlineIterate_ONSCREEN,		//	implies visible, twirled down, unshy

	OTLN_COutlineIterate_CHILDREN,		//	one level

	OTLN_COutlineIterate_ALL, 
	OTLN_COutlineIterate_SELECTED, 

	OTLN_COutlineIterate_SELECTED_COPY, 
	OTLN_COutlineIterate_DEEP_SELECTED, 
	OTLN_COutlineIterate_DEEP_SELECTED_COPY, 

	OTLN_COutlineIterate_NUMTYPES
} OTLN_COutlineIterateType;


/*******************************************
	Callback to Front End routines
*******************************************/

enum {
	OTLN_CB_NONE = -1, 
	
	//	Outline Only
	OTLN_CB_GET_FRAME, 

	//	Topic Only
	OTLN_CB_DRAW, 
	OTLN_CB_DRAG_REORDER, 
	OTLN_CB_TWIRL, 
	OTLN_CB_MARQUEE, 

	//	shared
	OTLN_CB_DUP_CUST_DATA, 
	OTLN_CB_DISPOSE_CUST_DATA, 
	
	//	user can add types and structs
	OTLN_CB_NUMTYPES, 

	//------------------------------------------------	
	//	types past here will call back to the 
	//	internal CB routine, not the front end one
	OTLN_CB_INTERNAL		= 32768, 
	OTLN_CB_HIT_TEST, 
	OTLN_CB_SELECT, 
	
	/*
		CLEAR RECTS is used to tell each topic that its screen
		rectangle is zero.  in all other Iterate operations, 
		the screen rect is updated to its actual position.  then
		you can see if a topic is onscreen by seeing if the screen
		rect is not zero
	*/
	OTLN_CB_CLEAR_RECTS, 
	OTLN_CB_COUNT
};
typedef		unsigned	short	OTLN_CBType;

typedef struct {
	//	for drag reorder, and possibly to see if onscreen and the like
	//	possibly replaces outline frame
	//	returns Pano frame of outline, not cell frame of topic
	Rect						frame;
} OTLN_CBData_GET_FRAME;

typedef struct {
	OTLN_DragReorderCBMessageType	message;
	Point							the_point;
	Rect							min_frame;
	Rect							max_frame;
	Boolean							scrolled;
} OTLN_CBData_DRAG_REORDER;

typedef struct {
	Boolean						down;
} OTLN_CBData_TWIRL;

typedef struct {
	void						*source_cust_data;
	
	OTLN_COutlineAndCTopic		dest_cot;
	void						*dest_cust_data;
} OTLN_CBData_DUP_CUST_DATA;

typedef struct {
	void						*cust_data;
} OTLN_CBData_DISPOSE_CUST_DATA;

typedef struct {
	Boolean						count_cells;
	long						count;
} OTLN_CBData_COUNT;

typedef struct {
	Point						hit_point;
	OTLN_CTopic					*cTopic;
} OTLN_CBData_HIT_TEST;

typedef struct {
	Boolean						select;
	Boolean						draw;
	OTLN_CTopic					*except0;
} OTLN_CBData_SELECT;

typedef struct {
	Boolean						scrub;
} OTLN_CBData_DRAW;

typedef struct {
	Rect						theRect;
	Boolean						toggleB;
} OTLN_CBData_MARQUEE;

typedef union {
	OTLN_CBData_GET_FRAME				frame;
	OTLN_CBData_DRAG_REORDER			drag;
	OTLN_CBData_TWIRL					twirl;
	OTLN_CBData_DUP_CUST_DATA			dup_cust;
	OTLN_CBData_DISPOSE_CUST_DATA		dispose_cust;
	OTLN_CBData_COUNT					count;
	OTLN_CBData_HIT_TEST				hit_test;
	OTLN_CBData_SELECT					select;
	OTLN_CBData_MARQUEE					marquee;
	OTLN_CBData_DRAW					draw;
} OTLN_CBData, *OTLN_CBDataP;

typedef		Err		(*OTLN_CBDispatchProc)(
	OTLN_COutlineAndCTopicP	cot, 
	OTLN_CBType				cbType, 
	OTLN_CBDataP			cbData
);


/*******************************************
	variables used during iterating the outline
*******************************************/
typedef	struct {
	OTLN_COutline				*cOutline;
	OTLN_OutlineP				ol;
	Rect						outline_frame;
	OTLN_COutlineIterateType	iterate_type;
	OTLN_CBType					cb_type;
	void						*data;			//	custom data during recursion
	short						v_pos;
	Boolean						go_wide;		//	do sisters, almost always true
	Boolean						go_deep;		//	do children, almost always true
} OTLN_IterateVars, *OTLN_IterateVarsP;

#include "O.h"

#endif